<?php

namespace App\Controllers;

use App\Models\ResearchJob;
use App\Services\AI\GeminiClient;
use App\Services\Agents\DiscoveryAgent;

class ApiController
{
    public function discover()
    {
        header('Content-Type: application/json');
        
        $input = json_decode(file_get_contents('php://input'), true);
        $topic = $input['topic'] ?? '';
        $params = $input['params'] ?? [];
        $lang = $params['language'] ?? 'Persian';

        if (empty($topic)) {
            echo json_encode(['error' => 'Topic is required']);
            return;
        }

        try {
            $client = new GeminiClient();
            $agent = new DiscoveryAgent($client);
            
            // --- تغییر مهم: استفاده از مدلی که در لیست شما وجود داشت ---
            // قبلی: 'gemini-1.5-pro' (که ارور داد)
            // جدید: 'gemini-3-pro-preview' (که متصل شده بودید و کار می‌کرد)
            $competitors = $agent->findCompetitors($topic, $lang, 'gemini-3-pro-preview');
            
            echo json_encode(['status' => 'success', 'sources' => $competitors]);
            
        } catch (\Exception $e) {
            // لاگ کردن خطای واقعی برای دیباگ راحت‌تر در آینده
            error_log("Discovery Error: " . $e->getMessage());
            echo json_encode(['error' => $e->getMessage()]);
        }
    }

    public function store()
    {
        $input = json_decode(file_get_contents('php://input'), true);
        $topic = $input['topic'] ?? '';
        $params = $input['params'] ?? [];
        $selectedSources = $input['selected_sources'] ?? [];

        if (!empty($selectedSources)) {
            $params['approved_sources'] = $selectedSources;
        }

        if (empty($topic)) {
            http_response_code(400);
            echo json_encode(['error' => 'Topic is required']);
            return;
        }

        $id = ResearchJob::create($topic, $params);
        echo json_encode(['job_id' => $id, 'status' => 'pending']);
    }

    public function status()
    {
        $id = $_GET['id'] ?? null;
        $job = ResearchJob::find($id);

        if (!$job) {
            http_response_code(404);
            echo json_encode(['error' => 'Not found']);
            return;
        }

        echo json_encode([
            'status' => $job['status'],
            'completed' => ($job['status'] === 'completed'),
            'redirect' => 'report?id=' . $id
        ]);
    }

    // اضافه کردن کلاس در بالای فایل: use App\Services\Agents\ConfigAgent;

    public function suggest()
    {
        header('Content-Type: application/json');
        
        $input = json_decode(file_get_contents('php://input'), true);
        $topic = $input['topic'] ?? '';
        $lang = $input['language'] ?? 'Persian';

        if (empty($topic)) {
            echo json_encode(['error' => 'Topic required']);
            return;
        }

        try {
            $client = new GeminiClient();
            $agent = new \App\Services\Agents\ConfigAgent($client); // استفاده مستقیم از ایجنت جدید
            
            $suggestions = $agent->suggestSettings($topic, $lang);
            
            echo json_encode(['status' => 'success', 'data' => $suggestions]);
            
        } catch (\Exception $e) {
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}