<?php

namespace App\Core;

class Router
{
    private array $routes = [];
    private string $baseDir; // اضافه شدن یک متغیر برای پایه مسیر

    public function __construct()
    {
        $this->baseDir = Env::get('APP_BASE_DIR', '/'); // از Env.php مقدار پایه را می‌گیریم
    }

    public function get(string $uri, array $action)
    {
        $this->routes['GET'][$uri] = $action;
    }

    public function post(string $uri, array $action)
    {
        $this->routes['POST'][$uri] = $action;
    }

    public function dispatch()
    {
        // گرفتن آدرس درخواستی کامل
        $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $method = $_SERVER['REQUEST_METHOD'];

        // حذف baseDir از ابتدای URI برای اینکه روتر فقط روت‌های تعریف شده را ببیند (مثل '/')
        // /deep-research-app/ -> /
        // /deep-research-app/report?id=... -> /report?id=...
        if (str_starts_with($uri, $this->baseDir)) {
            $uri = substr($uri, strlen($this->baseDir));
        }

        // اطمینان از اینکه URI بعد از حذف همچنان با '/' شروع شود
        if (empty($uri)) {
            $uri = '/';
        }


        if (isset($this->routes[$method][$uri])) {
            [$controllerClass, $methodName] = $this->routes[$method][$uri];
            
            $controller = new $controllerClass();
            return $controller->$methodName();
        }

        http_response_code(404);
        echo "404 - Not Found<br>Request URI: " . htmlspecialchars($uri) . "<br>Original URI: " . htmlspecialchars($_SERVER['REQUEST_URI']);
    }
}