<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class ResearchJob
{
    // ساخت یک تحقیق جدید توسط کاربر
    public static function create(string $topic, array $params = []): string
{
    $id = self::generateUUID();
    $pdo = Database::getInstance()->getConnection();

    // تبدیل آرایه پارامترها به JSON
    $jsonParams = json_encode($params, JSON_UNESCAPED_UNICODE);

    $stmt = $pdo->prepare("INSERT INTO research_jobs (id, user_topic, params, status, created_at) VALUES (:id, :topic, :params, 'pending', NOW())");
    
    $stmt->execute([
        ':id' => $id,
        ':topic' => $topic,
        ':params' => $jsonParams
    ]);

    return $id;
}

    // پیدا کردن اطلاعات یک تحقیق با ID (برای نمایش به کاربر)
    public static function find(string $id)
    {
        $pdo = Database::getInstance()->getConnection();
        $stmt = $pdo->prepare("SELECT * FROM research_jobs WHERE id = :id LIMIT 1");
        $stmt->execute([':id' => $id]);
        
        return $stmt->fetch();
    }

    // این متد را "Worker" صدا می‌زند تا ببیند کار جدیدی هست یا نه
    public static function getNextPendingJob()
    {
        $pdo = Database::getInstance()->getConnection();
        
        // ما قدیمی‌ترین درخواستی که وضعیتش 'pending' است را می‌گیریم
        $stmt = $pdo->query("SELECT * FROM research_jobs WHERE status = 'pending' ORDER BY created_at ASC LIMIT 1");
        
        return $stmt->fetch();
    }

    // بروزرسانی وضعیت و داده‌های پروژه
    public static function update(string $id, array $data)
    {
        $pdo = Database::getInstance()->getConnection();
        
        $fields = [];
        $params = [':id' => $id];

        foreach ($data as $key => $value) {
            $fields[] = "$key = :$key";
            $params[":$key"] = $value;
        }

        if (empty($fields)) {
            return;
        }

        $sql = "UPDATE research_jobs SET " . implode(', ', $fields) . " WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
    }

    // تابع کمکی برای تولید UUID (چون PHP قدیمی تابع داخلی UUID ندارد)
    private static function generateUUID(): string
    {
        return sprintf(
            '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000,
            mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
    }

    public static function getAll()
    {
        $pdo = \App\Core\Database::getInstance()->getConnection();
        $stmt = $pdo->query("SELECT * FROM research_jobs ORDER BY created_at DESC LIMIT 50");
        return $stmt->fetchAll();
    }
}