<?php

namespace App\Services\Agents;

use App\Services\AI\GeminiClient;

class ConfigAgent
{
    private GeminiClient $client;

    public function __construct(GeminiClient $client)
    {
        $this->client = $client;
    }

    public function suggestSettings(string $topic, string $language): array
    {
        $langInstruction = ($language === 'Persian' || $language === 'Farsi') 
            ? "Output MUST be in Persian (Farsi)." 
            : "Output MUST be in English.";

        $prompt = <<<EOT
        You are a Content Strategy AI. 
        Analyze this topic: "{$topic}"
        Language Context: {$language}.

        Your goal is to suggest the best content configuration for an SEO-optimized article about this topic.
        
        RETURN ONLY RAW JSON (No markdown). Structure:
        {
            "focus_keyword": "Best single keyword",
            "lsi_keywords": "comma, separated, related, keywords",
            "role": "Ideal AI Persona (e.g. Senior Tech Writer)",
            "audience": "Target Audience description",
            "tone": "Ideal Tone (e.g. Professional)",
            "context": "A short brief describing the article goal",
            "constraints": "Negative constraints relevant to topic",
            "type": "Blog Post"
        }

        {$langInstruction}
        EOT;

        // استفاده از مدل سریع (Flash) برای پاسخ آنی
        $response = $this->client->generateContent($prompt, 'gemini-2.5-flash', false, true); // true = forceJson
        
        $text = $response['candidates'][0]['content']['parts'][0]['text'] ?? '{}';
        
        // تمیزکاری
        $text = str_replace(['```json', '```'], '', $text);
        return json_decode($text, true) ?? [];
    }
}