<?php

namespace App\Services\Agents;

use App\Services\AI\GeminiClient;

class DiscoveryAgent
{
    private GeminiClient $client;

    public function __construct(GeminiClient $client)
    {
        $this->client = $client;
    }

    public function findCompetitors(string $topic, string $language, string $model): array
    {
        // تنظیمات لوکیشن بر اساس زبان
        $gl = 'US'; // Google Location code
        $hl = 'en'; // Google Language code
        $locationName = 'United States';
        
        if ($language === 'Persian' || $language === 'Farsi') {
            $gl = 'IR';
            $hl = 'fa';
            $locationName = 'Iran';
            // اگر کاربر انگلیسی نوشته ولی نتیجه فارسی می‌خواهد، موضوع را هم باید ترجمه کنیم
            $queryLogic = "IF the user input '{$topic}' is in English but the target is Persian, TRANSLATE it to Persian first (e.g., 'SEO' -> 'سئو'). Then search.";
        } else {
            $queryLogic = "Search for '{$topic}' directly.";
        }

        $prompt = <<<EOT
        Act as an Advanced SEO Serper Tool.
        Task: Simulate a Google Search result page (SERP).
        
        SETTINGS:
        - Query: "{$topic}"
        - Region (gl): {$gl} ({$locationName})
        - Language (hl): {$hl}
        
        INSTRUCTIONS:
        1. {$queryLogic}
        2. Identify the REAL top 10 organic results that a user in {$locationName} would see.
        3. Prioritize actual competitor sites (exclude basic dictionary definitions if competitive articles exist).
        4. ACCURACY IS CRITICAL: Do not hallucinate links.
        
        OUTPUT FORMAT (JSON ONLY):
        [
            {
                "rank": 1,
                "title": "Exact Page Title",
                "url": "https://valid-url...",
                "summary": "Short snippet in {$language}"
            }
        ]
        
        Requirement: Exactly 10 items.
        EOT;

        try {
            // Force JSON enabled
            $response = $this->client->generateContent($prompt, $model, true, true);
        } catch (\Exception $e) {
            return [['rank'=>0, 'title'=>'Error', 'url'=>'#', 'summary'=>$e->getMessage()]];
        }
        
        $text = $response['candidates'][0]['content']['parts'][0]['text'] ?? '[]';
        
        // تمیزکاری نهایی برای اطمینان
        if (preg_match('/\[.*\]/s', $text, $matches)) {
            $text = $matches[0];
        }

        $data = json_decode($text, true);
        return (is_array($data) && !empty($data)) ? $data : [];
    }
}