<?php

namespace App\Services\Agents;

use App\Services\AI\GeminiClient;

class PlannerAgent
{
    private GeminiClient $client;

    public function __construct(GeminiClient $client)
    {
        $this->client = $client;
    }

    public function generatePlan(string $topic, array $context = [], string $model = 'gemini-3-pro-preview', array $competitors = []): array
    {
        $audience = $context['audience'] ?? 'General';
        
        // ساخت لیستی از عناوین رقبا برای ارسال به هوش مصنوعی
        $competitorTitles = "";
        foreach ($competitors as $comp) {
            $competitorTitles .= "- " . ($comp['title'] ?? 'Source') . "\n";
        }

        $prompt = <<<EOT
        ACT AS: A Senior SEO Strategist & Content Architect.
        TARGET TOPIC: "{$topic}"
        AUDIENCE: "{$audience}"
        
        # COMPETITOR LANDSCAPE (What is already ranking on Google):
        {$competitorTitles}
        
        # YOUR MISSION (The Skyscraper Technique):
        We need to create the ULTIMATE content outline that outperforms all the above competitors.
        1. **Coverage:** Include all essential topics covered by competitors.
        2. **The Gap:** Identify 1-2 valuable sub-topics/angles that competitors MISSED and add them.
        3. **Structure:** Create a logical flow (H2s -> H3s) designed for high "Time on Page".
        
        # OUTPUT FORMAT:
        Return ONLY a raw JSON array of 5 to 7 specific search queries/sub-topics. These queries will be used to research the missing data.
        
        Example: ["topic definition and basics", "advanced strategies for topic", "common mistakes in topic", "future trends of topic"]
        EOT;

        $response = $this->client->generateContent($prompt, $model, false);
        
        $text = $response['candidates'][0]['content']['parts'][0]['text'] ?? '[]';
        $text = str_replace(['```json', '```'], '', $text);
        
        $data = json_decode(trim($text), true);
        return is_array($data) ? $data : [$topic . " basics", $topic . " advanced", $topic . " examples"];
    }
}