<?php
// public/index.php

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../vendor/autoload.php';

use App\Core\Env;
use App\Core\Router;
use App\Controllers\HomeController;
use App\Controllers\ApiController;
use App\Controllers\StreamController;

Env::load(__DIR__ . '/../.env');

$router = new Router();

// === Web Routes ===
$router->get('/', [HomeController::class, 'index']);
$router->get('/report', [HomeController::class, 'viewReport']);

// === API Routes ===
$router->post('/api/create', [ApiController::class, 'store']);
$router->get('/api/status', [ApiController::class, 'status']);
$router->post('/api/discover', [ApiController::class, 'discover']); // <--- اینجا درست شد

// === SSE Route ===
$router->get('/stream', [StreamController::class, 'handle']);
$router->get('/archive', [HomeController::class, 'archive']);
$router->post('/api/suggest', [ApiController::class, 'suggest']);



$router->dispatch();