<?php 
// دریافت آدرس پایه برای لینک‌های صحیح
$base = \App\Core\Env::get('APP_BASE_DIR'); 
ob_start(); 
?>

<div class="min-h-screen bg-[#F3F4F6] font-sans dir-rtl text-slate-800 p-6 md:p-10">
    
    <div class="max-w-7xl mx-auto">
        <!-- Header -->
        <div class="flex justify-between items-end mb-8 border-b border-slate-200 pb-4">
            <div>
                <h1 class="text-3xl font-black text-slate-800 mb-2">
                    🗄️ آرشیو <span class="text-indigo-600">پژوهش‌ها</span>
                </h1>
                <p class="text-slate-500 text-sm">لیست تمام مقالات و پژوهش‌های انجام شده توسط هوش مصنوعی</p>
            </div>
            
            <a href="<?php echo $base; ?>/" class="bg-slate-900 hover:bg-black text-white px-5 py-2.5 rounded-xl font-bold transition flex items-center gap-2 shadow-lg shadow-slate-300">
                <span class="text-lg">+</span> پژوهش جدید
            </a>
        </div>

        <!-- Jobs Grid/Table -->
        <div class="bg-white rounded-3xl shadow-xl shadow-slate-100 border border-slate-200 overflow-hidden">
            
            <?php if(empty($jobs) || !is_array($jobs)): ?>
                <!-- حالت خالی -->
                <div class="text-center py-24 flex flex-col items-center justify-center">
                    <div class="w-20 h-20 bg-slate-50 rounded-full flex items-center justify-center mb-4 text-4xl">📂</div>
                    <h3 class="text-xl font-bold text-slate-700 mb-2">آرشیو خالی است</h3>
                    <p class="text-slate-400">هنوز هیچ پژوهشی ثبت نشده است.</p>
                    <a href="<?php echo $base; ?>/" class="mt-6 text-indigo-600 font-bold hover:underline">شروع اولین نگارش</a>
                </div>
            <?php else: ?>

            <div class="overflow-x-auto">
                <table class="w-full text-right border-collapse">
                    <thead>
                        <tr class="bg-slate-50 border-b border-slate-200 text-xs font-bold text-slate-500 uppercase tracking-wide">
                            <th class="px-6 py-5">موضوع (Topic)</th>
                            <th class="px-6 py-5">وضعیت</th>
                            <th class="px-6 py-5">تاریخ ایجاد</th>
                            <th class="px-6 py-5 text-center">عملیات</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        <?php foreach($jobs as $item): ?>
                        <tr class="hover:bg-indigo-50/30 transition group">
                            
                            <!-- Topic Info -->
                            <td class="px-6 py-4">
                                <div class="font-bold text-slate-800 text-base mb-1 truncate max-w-lg" title="<?php echo htmlspecialchars($item['user_topic'] ?? ''); ?>">
                                    <?php echo htmlspecialchars($item['user_topic'] ?? 'بدون عنوان'); ?>
                                </div>
                                <?php 
                                    // نمایش جزئیات کوچک
                                    $reportLen = isset($item['final_report']) ? mb_strlen($item['final_report']) : 0;
                                    $wordCountEst = number_format($reportLen / 5);
                                ?>
                                <div class="flex gap-2 text-[10px] text-slate-400 font-mono">
                                    <span class="bg-slate-100 px-1.5 rounded">ID: <?php echo substr($item['id'], 0, 8); ?>...</span>
                                    <?php if($reportLen > 0): ?>
                                        <span class="text-green-600 bg-green-50 px-1.5 rounded border border-green-100">~<?php echo $wordCountEst; ?> کلمه</span>
                                    <?php endif; ?>
                                </div>
                            </td>

                            <!-- Status Badge -->
                            <td class="px-6 py-4">
                                <?php 
                                $status = $item['status'] ?? 'pending';
                                if($status === 'completed'): ?>
                                    <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full text-xs font-bold bg-green-100 text-green-700 border border-green-200">
                                        <span class="w-2 h-2 rounded-full bg-green-500 animate-pulse"></span> تکمیل
                                    </span>
                                <?php elseif($status === 'failed'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold bg-red-100 text-red-700 border border-red-200">
                                        خطا
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold bg-yellow-50 text-yellow-700 border border-yellow-200">
                                        در حال انجام
                                    </span>
                                <?php endif; ?>
                            </td>

                            <!-- Date -->
                            <td class="px-6 py-4 text-sm text-slate-500 dir-ltr font-mono text-right">
                                <?php echo $item['created_at']; ?>
                            </td>

                            <!-- Action Button -->
                            <td class="px-6 py-4 text-center">
                                <?php if(($item['status'] ?? '') === 'completed'): ?>
                                    <a href="<?php echo $base; ?>/report?id=<?php echo $item['id']; ?>" class="inline-flex items-center justify-center w-full max-w-[120px] bg-white border-2 border-slate-200 text-slate-600 hover:border-indigo-600 hover:text-indigo-600 px-4 py-2 rounded-xl text-xs font-extrabold transition shadow-sm group-hover:shadow-md">
                                        مشاهده
                                        <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                                    </a>
                                <?php else: ?>
                                    <span class="text-xs text-slate-300 select-none">—</span>
                                <?php endif; ?>
                            </td>

                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
/* CSS های ضروری */
body { direction: rtl; }
.dir-ltr { direction: ltr; }
.truncate { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
</style>

<?php 
$content = ob_get_clean(); 
include 'layout.php'; 
?>