<?php ob_start(); ?>

<link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />

<div class="flex h-screen w-full bg-[#FAFAFA] font-vazir dir-rtl text-slate-800 overflow-hidden">

    <aside class="w-[380px] md:w-[420px] flex-shrink-0 bg-white border-l border-slate-200 flex flex-col h-full shadow-[rgba(0,0,0,0.08)_5px_0_30px_-5px] z-30 transition-all relative">
        
        <div class="h-16 border-b border-slate-100 flex items-center justify-between px-6 shrink-0 bg-white sticky top-0 z-10">
            <h1 class="font-black text-xl text-slate-900 tracking-tight flex items-center gap-2">
                <span class="text-indigo-600 text-2xl">⚡</span> DeepWriter <span class="text-[10px] bg-slate-100 text-slate-500 px-2 py-0.5 rounded border">Pro Max</span>
            </h1>
        </div>

        <div class="flex-1 overflow-y-auto custom-scrollbar p-5 space-y-4 pb-32">
            <div class="group relative bg-white border border-indigo-100 rounded-2xl overflow-hidden shadow-sm hover:shadow-md transition-shadow">
                <div class="bg-indigo-50/50 px-5 py-3 border-b border-indigo-50 flex items-center justify-between cursor-default">
                    <span class="font-bold text-xs text-indigo-700 flex items-center gap-2">🎯 اطلاعات پایه</span>
                </div>
                <div class="p-5 space-y-4">
                    <div>
                        <label class="label-text">موضوع اصلی (Topic)</label>
                        <div class="relative">
                            <input type="text" id="topicInput" placeholder="مثلاً: راهنمای خرید بهترین گوشی..." class="input-field pl-8 focus:ring-2 focus:ring-indigo-100">
                            <button onclick="autoFillSettings()" id="btnAutoFill" class="absolute left-1.5 top-1.5 bottom-1.5 text-slate-400 hover:text-indigo-600 hover:bg-indigo-50 rounded-lg px-2 transition flex items-center justify-center" title="تکمیل هوشمند با AI">
                                <span class="text-lg">🪄</span>
                            </button>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="label-text">زبان</label>
                            <select id="langInput" class="input-field bg-slate-50 cursor-pointer">
                                <option value="Persian">فارسی</option>
                                <option value="English">English</option>
                            </select>
                        </div>
                        <div>
                            <label class="label-text text-white">_</label>
                            <button onclick="findSources()" id="btnFind" class="w-full bg-slate-800 text-white text-xs font-bold h-[38px] rounded-lg hover:bg-black transition flex items-center justify-center gap-2 shadow-lg shadow-slate-300">
                                🔍 یافتن منابع
                            </button>
                        </div>
                    </div>

                    <div id="sourcesSection" class="hidden pt-3 mt-3 border-t border-dashed border-indigo-100 animate-fade-in-up">
                        <div class="flex justify-between items-end mb-2">
                            <label class="label-text text-indigo-600">منابع ورودی</label>
                            <span class="text-[10px] text-slate-400 cursor-pointer hover:text-indigo-600" onclick="document.querySelectorAll('.src-cb').forEach(c=>c.checked=true)">انتخاب همه</span>
                        </div>
                        <div id="sourcesList" class="space-y-1.5 max-h-40 overflow-y-auto custom-scrollbar p-1 bg-slate-50 rounded-lg mb-2 border border-slate-100"></div>
                        <div class="flex gap-2">
                            <input id="manualLink" placeholder="لینک دستی..." class="input-field text-xs h-8">
                            <button onclick="addManualSource()" class="bg-slate-200 hover:bg-indigo-100 hover:text-indigo-700 text-slate-600 px-3 h-8 rounded-lg font-bold border border-slate-300 hover:border-indigo-300">+</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="border border-slate-200 rounded-2xl bg-white overflow-hidden shadow-sm hover:shadow-md transition">
                <button onclick="toggleAccordion('seoPanel')" class="w-full px-5 py-4 flex justify-between items-center bg-white hover:bg-slate-50 transition border-b border-transparent data-[open]:border-slate-100">
                    <span class="text-xs font-bold text-slate-700 flex items-center gap-2">🚀 سئو (SEO)</span>
                    <svg class="w-4 h-4 text-slate-400 transition-transform" id="arrow-seoPanel" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                </button>
                <div id="seoPanel" class="hidden p-5 pt-0 space-y-4 animate-fade-in-down bg-slate-50/50">
                    <div>
                        <label class="label-text">کلمه کلیدی اصلی</label>
                        <input id="focusKeyword" class="input-field border-green-200 focus:border-green-500 bg-green-50/20" placeholder="Main Keyword">
                    </div>
                    <div>
                        <label class="label-text">کلمات کلیدی LSI</label>
                        <textarea id="lsiKeywords" rows="2" class="input-field" placeholder="lsi1, lsi2..."></textarea>
                    </div>
                </div>
            </div>

            <div class="border border-slate-200 rounded-2xl bg-white overflow-hidden shadow-sm hover:shadow-md transition">
                <button onclick="toggleAccordion('stylePanel')" class="w-full px-5 py-4 flex justify-between items-center bg-white hover:bg-slate-50 transition">
                    <span class="text-xs font-bold text-slate-700 flex items-center gap-2">🎨 لحن و محتوا</span>
                    <svg class="w-4 h-4 text-slate-400 transition-transform" id="arrow-stylePanel" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                </button>
                <div id="stylePanel" class="hidden p-5 pt-0 space-y-4 animate-fade-in-down">
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="label-text">نوع صفحه (Page Type)</label>
                            <select id="typeInput" class="input-field cursor-pointer">
                                <option value="Blog Post">مقاله وبلاگ</option>
                                <option value="Product Review">نقد محصول</option>
                                <option value="Landing Page">لندینگ پیج</option>
                                <option value="News Report">خبر</option>
                            </select>
                        </div>
                        <div>
                            <label class="label-text">مخاطب</label>
                            <select id="audienceInput" class="input-field cursor-pointer">
                                <option value="General Public">عموم</option>
                                <option value="Experts">متخصصان</option>
                                <option value="B2B Managers">مدیران</option>
                            </select>
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="label-text">لحن</label>
                            <select id="toneInput" class="input-field cursor-pointer">
                                <option value="Professional">حرفه‌ای</option>
                                <option value="Friendly">دوستانه</option>
                                <option value="Persuasive">متقاعدکننده</option>
                                <option value="Critical">منتقدانه</option>
                            </select>
                        </div>
                        <div>
                            <label class="label-text">استراتژی (Angle)</label>
                            <select id="angleInput" class="input-field cursor-pointer">
                                <option value="Comprehensive">جامع (Skyscraper)</option>
                                <option value="Step-by-Step">گام‌به‌گام</option>
                                <option value="Comparison">مقایسه‌ای</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label class="label-text">زاویه دید</label>
                        <select id="povInput" class="input-field">
                            <option value="Third Person">سوم شخص (بی‌طرف)</option>
                            <option value="First Person">اول شخص (تجربی)</option>
                        </select>
                    </div>
                    <div>
                        <label class="label-text">نقش هوش مصنوعی (Persona)</label>
                        <input id="roleInput" class="input-field bg-indigo-50/30 border-indigo-100" placeholder="مثلاً: سردبیر ارشد محتوا">
                    </div>
                </div>
            </div>

            <div class="border border-slate-200 rounded-2xl bg-white overflow-hidden shadow-sm hover:shadow-md transition">
                <button onclick="toggleAccordion('advancedPanel')" class="w-full px-5 py-4 flex justify-between items-center bg-white hover:bg-slate-50 transition">
                    <span class="text-xs font-bold text-slate-700 flex items-center gap-2">🏢 برندینگ و جزئیات</span>
                    <svg class="w-4 h-4 text-slate-400 transition-transform" id="arrow-advancedPanel" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                </button>
                <div id="advancedPanel" class="hidden p-5 pt-0 space-y-4 animate-fade-in-down">
                    <div>
                        <label class="label-text">نام برند</label>
                        <input id="brandName" class="input-field" placeholder="نام برند شما">
                    </div>
                    <div>
                        <label class="label-text">دعوت به اقدام (CTA)</label>
                        <input id="ctaInput" class="input-field" placeholder="آخر متن چه بگوییم؟">
                    </div>
                    <div>
                        <label class="label-text">لینک‌سازی داخلی</label>
                        <textarea id="internalLinks" rows="2" class="input-field" placeholder="عنوان: لینک..."></textarea>
                    </div>
                    <div>
                        <label class="label-text text-slate-400">طول محتوا</label>
                        <select id="wordCountInput" class="input-field text-center font-mono">
                            <option value="1000">کوتاه (1000)</option>
                            <option value="1800" selected>استاندارد (1800)</option>
                            <option value="2500">جامع (2500)</option>
                            <option value="3500">پاورقی (3500+)</option>
                        </select>
                    </div>
                    <div>
                        <label class="label-text text-red-400 font-bold">کلمات ممنوعه (لیست سیاه)</label>
                        <textarea id="constraintsInput" rows="2" class="input-field bg-red-50/50 border-red-100 text-red-800" placeholder="چی نگم؟"></textarea>
                    </div>
                    <div class="flex items-center gap-2 pt-1">
                        <input type="checkbox" id="faqCheck" class="rounded w-4 h-4 text-indigo-600 focus:ring-0 border-slate-300" checked>
                        <label for="faqCheck" class="text-xs font-bold text-slate-700 cursor-pointer">بخش سوالات متداول (FAQ) اضافه شود</label>
                    </div>
                    
                    <input type="hidden" id="contextInput">
                </div>
            </div>

        </div>

        <div class="p-5 border-t border-slate-200 bg-white z-20 absolute bottom-0 w-full shadow-[0_-10px_40px_rgba(0,0,0,0.05)]">
            <button onclick="startWriting()" id="btnWrite" disabled class="w-full py-3.5 bg-slate-100 text-slate-400 rounded-xl font-bold text-sm transition-all flex items-center justify-center gap-2 cursor-not-allowed group shadow-sm hover:shadow-lg hover:scale-[1.02]">
                <span class="text-xl opacity-50 grayscale group-hover:grayscale-0 group-hover:animate-pulse">✨</span> 
                شروع نگارش حرفه‌ای
            </button>
        </div>
    </aside>

    <main class="flex-1 flex flex-col relative bg-[#F8FAFC] min-w-0">
        <header class="h-16 bg-white border-b border-slate-200 flex items-center justify-between px-8 sticky top-0 z-20 shadow-sm">
            <div class="flex items-center gap-4 text-xs text-slate-500">
                <span id="statusIndicator" class="w-2.5 h-2.5 rounded-full bg-slate-300"></span>
                <span id="statusText" class="font-bold">منتظر شروع...</span>
                <span id="percentBadge" class="opacity-0 font-mono text-indigo-600 transition">0%</span>
            </div>
            
            <div class="flex gap-2">
                <button onclick="copyCleanHTML()" class="btn-tool bg-white border border-slate-200 hover:border-indigo-300 text-slate-600 hover:text-indigo-600 shadow-sm">کپی HTML</button>
            </div>
        </header>

        <div class="w-full h-1 bg-slate-100 relative overflow-hidden"><div id="progressBar" class="absolute h-full bg-indigo-600 w-0 transition-all duration-500"></div></div>

        <div class="flex-1 overflow-y-auto p-8 md:p-12 custom-scrollbar flex justify-center bg-[#F8FAFC]">
            <div id="paperSheet" class="article-paper w-full max-w-[850px] min-h-[1100px] bg-white border border-slate-200 shadow-md rounded-xl p-14 md:p-20 relative transition-all duration-500 mb-20 group hover:shadow-xl">
                
                <div id="logsContainer" class="absolute top-4 left-0 right-0 flex flex-col items-center gap-2 pointer-events-none z-30 px-4"></div>
                
                <div id="emptyState" class="flex flex-col items-center justify-center h-[50vh] text-slate-300 select-none transition-opacity duration-300">
                    <div class="w-24 h-24 bg-slate-50 rounded-full flex items-center justify-center mb-6 shadow-inner">
                        <svg class="w-10 h-10 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z" /></svg>
                    </div>
                    <h2 class="text-lg font-bold text-slate-400 mb-1">فضای کاری خالی است</h2>
                    <p class="text-sm text-slate-300">از سایدبار سمت راست موضوع را وارد کنید.</p>
                </div>

                <textarea id="rawMarkdownStorage" class="hidden"></textarea>
                
                <article id="finalOutput" class="hidden prose prose-slate prose-lg max-w-none dir-auto animate-fade-in-up
                    prose-headings:font-black prose-headings:tracking-tight
                    prose-h1:text-3xl prose-h1:text-slate-900 prose-h1:mb-8
                    prose-p:text-slate-700 prose-p:leading-9 prose-p:text-justify prose-p:mb-6
                    prose-a:text-indigo-600 prose-a:no-underline prose-a:border-b prose-a:border-indigo-200 hover:prose-a:bg-indigo-50 hover:prose-a:border-indigo-600 prose-a:transition-all
                    prose-strong:text-slate-900 prose-strong:font-extrabold
                    prose-img:rounded-xl prose-img:shadow-lg prose-img:my-8
                "></article>
            </div>
        </div>
    </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
<script>
// همان اسکریپت‌های قبلی شما بدون تغییر
const BASE_URL = "<?php echo \App\Core\Env::get('APP_BASE_DIR'); ?>";
let foundSources = [];

function toggleAccordion(id) {
    const el = document.getElementById(id);
    const arrow = document.getElementById(`arrow-${id}`);
    const isHidden = el.classList.contains('hidden');
    if(isHidden) {
        el.classList.remove('hidden');
        arrow.style.transform = 'rotate(180deg)';
        el.scrollIntoView({behavior: 'smooth', block: 'nearest'});
    } else {
        el.classList.add('hidden');
        arrow.style.transform = 'rotate(0deg)';
    }
}

async function findSources() {
    const topic = document.getElementById('topicInput').value.trim();
    const lang = document.getElementById('langInput').value;
    if(!topic) return alert('موضوع خالی است');

    const btn = document.getElementById('btnFind');
    const oldTxt = btn.innerText;
    btn.innerHTML = '<span class="animate-spin">⏳</span>'; btn.disabled = true;

    try {
        const res = await fetch(BASE_URL + '/api/discover', {
            method: 'POST',
            body: JSON.stringify({ topic, params: { language: lang } }),
            headers: {'Content-Type': 'application/json'}
        });
        const data = await res.json();
        if(data.error) throw new Error(data.error);

        foundSources = data.sources || [];
        renderSources();
        document.getElementById('sourcesSection').classList.remove('hidden');
        enableWriteButton();
        
    } catch(e) { alert(e.message); }
    finally { btn.innerHTML = oldTxt; btn.disabled = false; }
}

function enableWriteButton() {
    const btn = document.getElementById('btnWrite');
    if(btn) {
        btn.disabled = false;
        btn.classList.remove('bg-slate-100', 'text-slate-400', 'cursor-not-allowed');
        btn.classList.add('bg-indigo-600', 'text-white', 'hover:bg-indigo-700', 'cursor-pointer');
    }
}

function renderSources() {
    const list = document.getElementById('sourcesList');
    list.innerHTML = '';
    foundSources.forEach((item, idx) => {
        list.innerHTML += `
            <div class="flex items-start gap-2 p-2 hover:bg-slate-100 rounded border border-transparent hover:border-slate-200 transition cursor-pointer" onclick="toggleCb(${idx})">
                <input type="checkbox" id="src_${idx}" checked class="src-cb mt-1 rounded text-indigo-600 focus:ring-0 cursor-pointer" onclick="event.stopPropagation()">
                <div class="flex-1 min-w-0">
                    <div class="text-[11px] font-bold text-slate-700 truncate">${item.title}</div>
                    <div class="text-[9px] text-slate-400 dir-ltr text-right truncate">${new URL(item.url).hostname}</div>
                </div>
                <a href="${item.url}" target="_blank" class="text-blue-400 hover:text-blue-600" onclick="event.stopPropagation()">↗</a>
            </div>`;
    });
}
function toggleCb(i) { const el=document.getElementById(`src_${i}`); el.checked = !el.checked; }
function addManualSource() { 
    const inp = document.getElementById('manualLink');
    if(inp.value){ foundSources.unshift({title:"Link Manual", url:inp.value}); renderSources(); inp.value=''; } 
}

async function autoFillSettings() {
    const topic = document.getElementById('topicInput').value.trim();
    if(!topic) return alert('موضوع را وارد کنید');
    const btn = document.getElementById('btnAutoFill');
    btn.innerHTML = '...';
    try {
        const res = await fetch(BASE_URL + '/api/suggest', {
            method: 'POST', body: JSON.stringify({topic, language: 'Persian'}), headers: {'Content-Type': 'application/json'}
        });
        const d = (await res.json()).data;
        if(d) {
            setVal('focusKeyword', d.focus_keyword);
            setVal('lsiKeywords', d.lsi_keywords);
            setVal('roleInput', d.role);
            setVal('contextInput', d.context);
            ['seoPanel', 'stylePanel', 'advancedPanel'].forEach(id => document.getElementById(id).classList.remove('hidden'));
            alert('✨ تنظیمات سئو و محتوا توسط AI پر شد!');
        }
    } catch(e){ console.error(e); } 
    finally { btn.innerHTML = '🪄'; }
}

function setVal(id, val) { 
    const el = document.getElementById(id);
    if(el && val) { el.value = val; el.style.borderColor='#6366f1'; setTimeout(()=>el.style.borderColor='',1000); }
}

async function startWriting() {
    const selected = foundSources.filter((_, i) => document.getElementById(`src_${i}`)?.checked);
    if(selected.length===0 && !confirm("بدون منبع؟")) return;

    const params = {
        language: document.getElementById('langInput').value,
        word_count: document.getElementById('wordCountInput').value,
        type: document.getElementById('typeInput').value,
        role: document.getElementById('roleInput').value,
        audience: document.getElementById('audienceInput').value,
        tone: document.getElementById('toneInput').value,
        pov: document.getElementById('povInput').value,
        angle: document.getElementById('angleInput').value,
        focus_keyword: document.getElementById('focusKeyword').value,
        lsi_keywords: document.getElementById('lsiKeywords').value,
        brand_name: document.getElementById('brandName').value,
        cta: document.getElementById('ctaInput').value,
        internal_links: document.getElementById('internalLinks').value,
        constraints: document.getElementById('constraintsInput').value,
        context: document.getElementById('contextInput').value,
        include_faq: document.getElementById('faqCheck').checked,
    };

    document.getElementById('emptyState').classList.add('hidden');
    document.getElementById('finalOutput').classList.remove('hidden');
    document.getElementById('finalOutput').innerHTML = '<div class="mt-20 text-center animate-pulse text-slate-400">در حال اتصال به مغز هوش مصنوعی...</div>';
    document.getElementById('percentBadge').classList.remove('opacity-0');
    setStatus('آغاز عملیات...', 'bg-indigo-500', 'text-indigo-600');

    try {
        const res = await fetch(BASE_URL + '/api/create', {
            method: 'POST',
            body: JSON.stringify({ 
                topic: document.getElementById('topicInput').value, 
                params, selected_sources: selected 
            }),
            headers: {'Content-Type': 'application/json'}
        });
        const data = await res.json();
        if(data.error) throw new Error(data.error);
        startStream(data.job_id);
    } catch(e) { alert(e.message); }
}

function startStream(id) {
    const src = new EventSource(BASE_URL + '/stream?id=' + id);
    src.addEventListener('log', e => showToast(JSON.parse(e.data)));
    src.addEventListener('progress', e => {
        const d = JSON.parse(e.data);
        setStatus(d.message);
        document.getElementById('percentBadge').innerText = d.percent + '%';
        document.getElementById('progressBar').style.width = d.percent + '%';
    });
    src.addEventListener('complete', e => {
        src.close();
        setStatus('تکمیل شد.', 'bg-green-500', 'text-green-600');
        fetchReport(JSON.parse(e.data).redirect);
    });
    src.addEventListener('error', e => { 
        src.close(); if(e.data) showToast("Error: "+JSON.parse(e.data).message, 'error'); 
        setStatus('متوقف شد', 'bg-red-500', 'text-red-500');
    });
}

async function fetchReport(url) {
    const iframe = document.createElement('iframe');
    iframe.style.display = 'none'; iframe.src = BASE_URL + '/' + url;
    document.body.appendChild(iframe);
    iframe.onload = function() {
        try {
            const raw = iframe.contentDocument.getElementById('rawMarkdown').innerText;
            document.getElementById('rawMarkdownStorage').value = raw;
            document.getElementById('finalOutput').innerHTML = marked.parse(raw);
            document.body.removeChild(iframe);
        } catch(e){}
    }
}

function showToast(msg, type='info') {
    const box = document.getElementById('logsContainer');
    const d = document.createElement('div');
    const bg = type==='error' ? 'bg-red-600' : 'bg-slate-800';
    d.className = `${bg} text-white text-[10px] px-3 py-1.5 rounded-full shadow-lg opacity-90 animate-fade-in-up flex items-center gap-2 backdrop-blur-sm`;
    d.innerHTML = `<span class="w-1.5 h-1.5 bg-white rounded-full animate-pulse"></span> ${msg}`;
    box.appendChild(d);
    setTimeout(() => { d.style.opacity='0'; setTimeout(()=>d.remove(),300) }, 3000);
}

function setStatus(t, bg, txt) {
    document.getElementById('statusText').innerText = t;
    document.getElementById('statusIndicator').className = `w-2.5 h-2.5 rounded-full ${bg}`;
    if(txt) document.getElementById('statusText').className = `font-bold text-xs ${txt}`;
}

function copyCleanHTML() {
    const c = document.createElement('div');
    c.innerHTML = document.getElementById('finalOutput').innerHTML;
    c.querySelectorAll('span[style]').forEach(s => s.replaceWith(s.textContent));
    navigator.clipboard.writeText(c.innerHTML).then(() => showToast('کد تمیز کپی شد! ✅'));
}
</script>

<style>
/* FONT SETTINGS */
.font-vazir { font-family: 'Vazirmatn', sans-serif; }

/* SIDEBAR STYLES */
.label-text { font-size: 10px; font-weight: bold; color: #64748b; margin-bottom: 4px; display: block; }
.input-field { width: 100%; font-size: 11px; padding: 8px; border-radius: 8px; border: 1px solid #e2e8f0; background: #fff; outline: none; transition: 0.2s; color:#334155; }
.input-field:focus { border-color: #6366f1; box-shadow: 0 0 0 3px rgba(99,102,241,0.05); }
.btn-tool { font-size: 11px; font-weight: bold; padding: 6px 12px; rounded: 8px; transition: 0.2s; display: flex; align-items: center; gap: 4px; }

/* GENERAL SCROLLBAR */
::-webkit-scrollbar { width: 6px; } 
::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
::-webkit-scrollbar-thumb:hover { background: #94a3b8; }

/* ANIMATIONS */
.animate-fade-in-down { animation: fadeInDown 0.3s ease-out forwards; }
@keyframes fadeInDown { from { opacity:0; transform:translateY(-10px); } to { opacity:1; transform:translateY(0); } }
.animate-fade-in-up { animation: fadeInUp 0.4s ease-out forwards; }
@keyframes fadeInUp { from { opacity:0; transform:translateY(10px); } to { opacity:1; transform:translateY(0); } }

/* ========================================= */
/* PROFESSIONAL CONTENT STYLING (THE KEY)   */
/* ========================================= */

/* Selection Color */
::selection { background: #6366f1; color: white; }

/* H2 Styling */
.prose h2 { 
    color: #1e293b; 
    margin-top: 2em; 
    margin-bottom: 1em;
    padding-right: 16px; 
    border-right: 4px solid #6366f1; 
    font-size: 1.5rem;
    line-height: 1.4;
    position: relative;
}

/* H3 Styling */
.prose h3 {
    color: #334155;
    margin-top: 1.8em;
    font-size: 1.25rem;
    font-weight: 800;
    display: flex;
    align-items: center;
    gap: 8px;
}
.prose h3::before {
    content: '#';
    color: #cbd5e1;
    font-weight: 400;
}

/* Blockquote Styling */
.prose blockquote {
    font-style: normal;
    font-weight: 500;
    color: #475569;
    border-right: 4px solid #818cf8; /* Light Indigo */
    background: #f8fafc; /* Very light gray/blue */
    padding: 16px 20px;
    border-radius: 8px 0 0 8px;
    margin: 2em 0;
    quotes: none;
}

/* Table Styling */
.prose table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    overflow: hidden;
    margin: 2em 0;
    font-size: 0.95em;
}
.prose thead { background: #f1f5f9; }
.prose th { color: #334155; padding: 12px 16px; text-align: right; font-weight: 800; border-bottom: 1px solid #e2e8f0; }
.prose td { padding: 12px 16px; border-bottom: 1px solid #f1f5f9; color: #475569; }
.prose tr:last-child td { border-bottom: none; }
.prose tr:nth-child(even) { background: #fafafa; }

/* Lists Styling (RTL Fixes) */
.prose ul > li { position: relative; padding-right: 1.2em; margin-bottom: 0.5em; }
.prose ul > li::before {
    content: '';
    position: absolute;
    right: 0;
    top: 0.7em;
    width: 6px;
    height: 6px;
    border-radius: 50%;
    background: #6366f1;
}
.prose ol { list-style-type: decimal; padding-right: 1.2em; color: #64748b; font-weight: bold; }
.prose ol li::marker { color: #6366f1; font-weight: 800; }

/* Code Blocks */
.prose pre {
    direction: ltr;
    text-align: left;
    background: #1e293b;
    border-radius: 12px;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
}
</style>

<?php $content = ob_get_clean(); include 'layout.php'; ?>