<?php
// تشخیص صفحه جاری برای تنظیم اسکرول
$uri = $_SERVER['REQUEST_URI'];
// اگر در صفحه اصلی بودیم، اسکرول مخفی شود (حالت اپلیکیشن)
// در غیر این صورت (آرشیو یا گزارش)، اسکرول باز باشد
$isDashboard = (strpos($uri, 'report') === false && strpos($uri, 'archive') === false);
$overflowStyle = $isDashboard ? 'overflow: hidden;' : 'overflow-y: auto;';
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deep Research Agent</title>
    
    <!-- فونت و استایل -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/themes/prism.min.css" rel="stylesheet" />

    <style>
        body, html { 
            font-family: 'Vazirmatn', sans-serif; 
            height: 100%; 
            margin: 0; 
            padding: 0;
            background-color: #f8fafc;
            /* استایل داینامیک اسکرول */
            <?= $overflowStyle ?>
        }
    </style>
</head>
<body>
    <?php echo $content; ?>
</body>
</html>