<?php 
// دریافت مسیر پایه
$base = \App\Core\Env::get('APP_BASE_DIR'); 
// دیکود کردن محتوا برای استفاده در جاوااسکریپت (جهت کپی کردن)
$finalContentRaw = $job['final_report'] ?? '';
ob_start(); 
?>

<div class="bg-[#F1F5F9] min-h-screen font-sans dir-rtl text-slate-800 pb-20">

    <!-- ================= TOP BAR (چسبان) ================= -->
    <div class="sticky top-0 z-50 bg-white/90 backdrop-blur-md border-b border-slate-200 h-16 flex items-center justify-between px-6 lg:px-12 shadow-sm transition-all">
        
        <!-- راست: اطلاعات کلی -->
        <div class="flex items-center gap-4">
            <a href="<?php echo $base; ?>/archive" class="group flex items-center gap-2 text-slate-500 hover:text-slate-900 transition text-sm font-bold bg-slate-100 hover:bg-slate-200 px-3 py-1.5 rounded-lg">
                <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                بازگشت به آرشیو
            </a>
            
            <div class="hidden md:flex h-5 w-px bg-slate-300 mx-2"></div>
            
            <h1 class="hidden md:block text-sm font-bold text-slate-700 truncate max-w-md">
                <?php echo htmlspecialchars($job['user_topic']); ?>
            </h1>
        </div>

        <!-- چپ: دکمه‌ها -->
        <div class="flex items-center gap-3">
            <div id="copyTooltip" class="opacity-0 transition-opacity text-xs font-bold text-green-600 bg-green-50 px-2 py-1 rounded">کپی شد!</div>
            
            <button onclick="copyCleanHTML()" class="flex items-center gap-2 bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg text-xs font-bold transition shadow-md hover:shadow-lg active:scale-95">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/></svg>
                کپی HTML تمیز
            </button>
            
            <button onclick="copyMarkdown()" class="hidden md:flex items-center gap-2 bg-white border border-slate-300 text-slate-600 hover:text-indigo-600 hover:border-indigo-300 px-4 py-2 rounded-lg text-xs font-bold transition">
                MD
            </button>
        </div>
    </div>

    <!-- ================= PAPER SHEET (بدنه اصلی) ================= -->
    <div class="max-w-4xl mx-auto mt-10 px-4">
        
        <!-- هدر مقاله روی کاغذ -->
        <div class="bg-white rounded-t-3xl border-x border-t border-slate-200 p-10 md:p-14 pb-0 text-center relative overflow-hidden">
            <!-- نوار رنگی بالا -->
            <div class="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-indigo-500 to-purple-600"></div>
            
            <div class="inline-block bg-indigo-50 text-indigo-700 text-[10px] font-mono font-bold px-3 py-1 rounded-full mb-4 border border-indigo-100">
                PRO REPORT GENERATED BY GEMINI 3.0
            </div>
            
            <h1 class="text-3xl md:text-4xl font-black text-slate-900 leading-tight mb-4">
                <?php echo htmlspecialchars($job['user_topic']); ?>
            </h1>
            
            <div class="flex justify-center gap-4 text-xs text-slate-400 font-mono">
                <span><?php echo $job['created_at']; ?></span>
                <span>•</span>
                <span>ID: <?php echo substr($job['id'], 0, 8); ?></span>
            </div>
        </div>

        <!-- متن مقاله -->
        <div class="bg-white rounded-b-3xl border border-slate-200 p-10 md:p-14 shadow-2xl shadow-slate-200/60 min-h-[500px]">
            
            <!-- کانتینر تایپوگرافی -->
            <article id="reportContent" class="prose prose-slate prose-lg max-w-none prose-headings:font-black prose-p:text-slate-600 prose-p:leading-8 prose-li:text-slate-600 dir-auto text-justify">
                <!-- اسپینر لودینگ -->
                <div class="flex items-center justify-center py-20 animate-pulse text-slate-300 gap-2">
                    <div class="w-3 h-3 bg-slate-300 rounded-full"></div>
                    <div class="w-3 h-3 bg-slate-300 rounded-full"></div>
                    <div class="w-3 h-3 bg-slate-300 rounded-full"></div>
                </div>
            </article>

        </div>

    </div>

    <!-- پاورقی -->
    <div class="text-center mt-8 text-slate-400 text-xs font-mono">
        Deep Research Agent • Powered by AI
    </div>

    <!-- مخزن مخفی متن خام -->
    <textarea id="rawMarkdown" class="hidden"><?php echo $finalContentRaw; ?></textarea>

</div>

<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
<script>
    // 1. رندر کردن محتوا بلافاصله پس از لود
    window.addEventListener('DOMContentLoaded', () => {
        const rawMd = document.getElementById('rawMarkdown').value;
        const container = document.getElementById('reportContent');
        
        if (rawMd.trim().length > 0) {
            // تبدیل مارک‌داون به HTML
            let html = marked.parse(rawMd);
            
            // اصلاح ظاهری SEO Package (اختیاری)
            // اگر در متن کلمه SEO PACKAGE بود، آن را داخل یک باکس خوشکل می‌گذاریم
            // البته معمولا markdown renderer خوب عمل میکنه. اینجا کلاس اضافه میکنیم:
            
            container.innerHTML = html;
            
            // پیدا کردن اولین لیست (معمولا متادیتا) و استایل دادن بهش
            const firstUl = container.querySelector('ul');
            if(firstUl && firstUl.previousElementSibling && firstUl.previousElementSibling.innerText.includes('SEO')) {
                firstUl.classList.add('bg-slate-50', 'p-6', 'rounded-xl', 'border', 'border-slate-100', 'text-sm', 'not-prose');
                firstUl.querySelectorAll('strong').forEach(el => el.classList.add('text-indigo-700'));
            }

        } else {
            container.innerHTML = `
                <div class="text-center py-10">
                    <p class="text-red-500 font-bold">متن گزارش یافت نشد یا خالی است.</p>
                    <a href="<?php echo $base; ?>/archive" class="text-blue-500 text-sm mt-2 block underline">بازگشت به لیست</a>
                </div>
            `;
        }
    });

    // 2. تابع کپی HTML تمیز (بدون هایلایت‌های سبز)
    function copyCleanHTML() {
        const contentDiv = document.createElement('div');
        // کپی گرفتن از DOM فعلی
        contentDiv.innerHTML = document.getElementById('reportContent').innerHTML;

        // حذف استایل‌های inline (مثل رنگ سبز هایلایت)
        // این کار تگ های span با استایل رو پیدا میکنه و محتواشون رو میکشه بیرون
        const spans = contentDiv.querySelectorAll('span[style]');
        spans.forEach(span => {
            const textNode = document.createTextNode(span.textContent);
            span.parentNode.replaceChild(textNode, span);
        });

        // تمیزکاری بیشتر (حذف کلاس‌های tailwind اضافه اگر نیاز بود)
        // navigator copy
        navigator.clipboard.writeText(contentDiv.innerHTML).then(() => {
            showToast("HTML تمیز برای وردپرس کپی شد! ✅");
        }).catch(err => {
            console.error('Copy failed', err);
            alert('مشکل در کپی. لطفا دستی انتخاب کنید.');
        });
    }

    // 3. کپی مارک‌داون
    function copyMarkdown() {
        const raw = document.getElementById('rawMarkdown').value;
        navigator.clipboard.writeText(raw).then(() => showToast("Markdown کپی شد!"));
    }

    function showToast(msg) {
        const el = document.getElementById('copyTooltip');
        el.innerText = msg;
        el.classList.remove('opacity-0');
        setTimeout(() => el.classList.add('opacity-0'), 2000);
    }
</script>

<style>
/* CSS Reset برای پرینت و خوانایی */
body { direction: rtl; }
.dir-ltr { direction: ltr; }
.dir-auto { direction: rtl; text-align: justify; text-justify: inter-word; }

/* اسکرول بار زیبا برای کل صفحه */
::-webkit-scrollbar { width: 8px; }
::-webkit-scrollbar-track { background: #f1f5f9; }
::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 4px; }
::-webkit-scrollbar-thumb:hover { background: #94a3b8; }

/* تایپوگرافی اختصاصی مقاله */
.prose { font-family: 'Vazirmatn', sans-serif; }

/* هدینگ‌ها */
.prose h1 { display: none; } /* تایتل اصلی رو جدا گذاشتیم */
.prose h2 { 
    font-size: 1.6em; 
    margin-top: 1.8em; 
    margin-bottom: 0.8em; 
    color: #1e293b; 
    position: relative;
    padding-right: 15px;
}
.prose h2::before {
    content: '';
    position: absolute;
    right: 0;
    top: 5px;
    bottom: 5px;
    width: 4px;
    background: #4f46e5; /* indigo-600 */
    border-radius: 4px;
}

.prose h3 {
    font-size: 1.25em;
    color: #334155;
    margin-top: 1.5em;
    margin-bottom: 0.5em;
    font-weight: 800;
}

/* پاراگراف‌ها و فاصله‌ها */
.prose p { margin-bottom: 1.5em; line-height: 2.1; color: #475569; }
.prose ul, .prose ol { margin-bottom: 1.5em; padding-right: 1.5em; }
.prose li { margin-bottom: 0.5em; }
.prose strong { color: #0f172a; font-weight: 800; }

/* لینک‌ها */
.prose a { color: #2563eb; text-decoration: none; border-bottom: 1px dotted; transition: 0.2s; }
.prose a:hover { background: #eff6ff; color: #1d4ed8; }

/* بلاک نقل قول */
.prose blockquote { 
    font-style: italic; 
    border-right: 4px solid #cbd5e1; 
    padding-right: 1em; 
    margin-right: 0; 
    color: #64748b; 
    background: #f8fafc;
    padding: 1rem;
    border-radius: 0.5rem;
}
</style>

<?php 
$content = ob_get_clean(); 
include 'layout.php'; 
?>