<?php
namespace Controllers;

use Models\RankModel;

class SeoController {
    public function index() {
        include 'views/form.php';
    }

    public function analyze() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['keyword_file'])) {
            $targetUrl = $_POST['url']; // آدرس سایتی که میخواهیم رتبه اش را بسنجیم
            $file = $_FILES['keyword_file']['tmp_name'];
            
            $keywords = [];
            // خواندن فایل CSV
            if (($handle = fopen($file, "r")) !== FALSE) {
                // رد کردن خط اول (هدر فایل گوگل پلنر)
                fgetcsv($handle, 1000, ","); 

                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    // در فایل گوگل پلنر معمولا ستون اول کلمه و ستون دوم حجم جستجو است
                    $keywords[] = [
                        'text' => $data[0],
                        'volume' => $data[1] ?? 0
                    ];
                }
                fclose($handle);
            }

            // حالا چک کردن رتبه برای تک تک کلمات
            $rankModel = new RankModel();
            $results = [];

            foreach ($keywords as $kw) {
                // پیدا کردن رتبه سایت در این کلمه
                $rank = $rankModel->checkRank($targetUrl, $kw['text']);
                
                $results[] = [
                    'keyword' => $kw['text'],
                    'volume' => $kw['volume'],
                    'rank' => $rank
                ];
            }

            include 'views/results.php';
        }
    }
}