<?php
namespace Models;

use Google\Ads\GoogleAds\Lib\V14\GoogleAdsClientBuilder;
use Google\Ads\GoogleAds\Lib\OAuth2TokenBuilder;
use Google\Ads\GoogleAds\V14\Services\GenerateKeywordIdeasRequest;
use Google\Ads\GoogleAds\V14\Services\UrlSeed;

class KeywordModel {
    private $client;
    private $customerId = '489-710-3080'; // شناسه شما

    public function __construct() {
        $oauth2Credential = (new OAuth2TokenBuilder())->fromFile()->build();
        $this->client = (new GoogleAdsClientBuilder())
            ->fromFile()
            ->withOAuth2Credential($oauth2Credential)
            ->build();
    }

    public function getKeywordsFromUrl($url) {
        $keywordPlanIdeaService = $this->client->getKeywordPlanIdeaServiceClient();
        
        $request = new GenerateKeywordIdeasRequest();
        $request->setCustomerId($this->customerId);
        $request->setLanguage('languageConstants/1039'); // Persian

        $urlSeed = new UrlSeed();
        $urlSeed->setUrl($url);
        $request->setUrlSeed($urlSeed);

        $response = $keywordPlanIdeaService->generateKeywordIdeas($request);
        
        $keywords = [];
        foreach ($response->iterateAllElements() as $result) {
            $keywords[] = [
                'text' => $result->getText(),
                'volume' => $result->getKeywordIdeaMetrics() ? $result->getKeywordIdeaMetrics()->getAvgMonthlySearches() : 0
            ];
        }
        return $keywords;
    }
}